<?php

namespace Database\Seeders;

use App\Models\AssetHealthCategory;
use App\Models\AssetHealthTests;
use Illuminate\Database\Seeder;

class AssetHealthTestsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $categoryTests = [
            'Errors' => [
                'end_of_life_wiped_with_no_certificate' => 'End Of Life Wiped, With No Certificate',
                'end_of_life_wiped_checking_in' => 'End Of Life Wiped, Checking In',
                'lost_or_stolen_no_locked' => 'Lost/Stolen, Not Locked',
                'lost_or_stolen_checking_in' => 'Lost/Stolen, Checking In',
                //'Legal Hold, not backed up',
                'user_discrepancy' => 'User Discrepancy',
                'assigned_device_not_active' => 'Assigned, Device Not Active',
                'not_in_mdm' => 'Not In MDM',
                'assigned_to_inactive_user' => 'Assigned To Inactive User',
                'device_on_hand_checked_in' => 'On Hand, Checking In',
                'managed_deployed_not_checked_in' => 'Managed & Deployed, Not Checking In',
                'not_created_checking_in' => 'Not Created, Checking In',
            ],
            'Warnings' => [
                'damaged_longer_than_30_days' => 'Damaged Longer Than 30 Days',
                'asset_age_over_3_years' => 'Asset Age Over 3 Years',
                'overdue_loaner' => 'Overdue Loaner',
                'overdue_retain_hold' => 'Overdue Retain Hold',
                'installed_in_inactive_location' => 'Installed In Inactive Location',
            ],
            'Notices' => [
                'missing_po' => 'Missing PO#',
                'missing_vendor' => 'Missing Vendor',
                'missing_purchase_price' => 'Missing Purchase Price',
                'warranty_expired' => 'Warranty Expired'
            ],
        ];

        foreach($categoryTests as $category => $tests) {

            $category_id = AssetHealthCategory::firstOrCreate([
                'category_name' => $category,
                'slug' => str_slug($category, '_'),
            ])->id;

        	foreach($tests as $slug => $test) {
                AssetHealthTests::firstOrCreate([
                    'slug' => $slug,
                    'test_name' => $test,
                    'category_id' => $category_id
            	]);

            }
        }
    }
}
