<?php

namespace Database\Seeders;

use App\Models\Asset;
use App\Models\AssetStatus;
// Commented use App\User;
use Illuminate\Database\Seeder;

class AsnAssetSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $intransit = AssetStatus::where('slug', 'shi_in_transit')->first();

        Asset::factory()->hasAssetHistory(1, function (array $attributes, Asset $asset) use ($intransit) {

            return [
                // 'user_id' => User::admin()->inRandomOrder()->first()->id,
                'ticket_no' => random_int(9999, 99999999),
                'asset_id' => $asset->id,
                'action' => 'imported_by_vendor',
                'new_asset_status_id' => $intransit->id,
                'description' =>  __('history.ImportedByVendor', [
                    'asset_name' => $asset->serial_no,
                    'asset_id' => $asset->id
                ]),
                'created_by' => 'SHI Import',
            ];
        })->count(100)->create();
    }
}
