<?php

namespace Database\Seeders;

use App\Models\ApiCredential;
use Illuminate\Database\Seeder;

class ApiCredentialsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        ApiCredential::truncate();
        $credentials = [
            [
                'name' => 'Jira',
                'slug' => 'jira',
                'url' => 'https://teqube.atlassian.net',
                'username' => 'hello@teqube.com',
                'password' => 'Teq1234!@',
                'key' => 'AM',
                'project' => 'AM-Tool'
            ],
        ];

        foreach ($credentials as $credential) {
            ApiCredential::create([
                'api_name' => $credential['name'],
                'slug' => $credential['slug'],
                'url' => $credential['url'],
                'user_name' => $credential['username'],
                'password' => encrypt($credential['password']),
                'key' => $credential['key'],
                'project' => $credential['project']
            ]);
        }
    }
}
