<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('zoom_devices', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id')->nullable();
            $table->integer('location_id')->nullable();
            $table->string('zoom_location_id')->nullable();
            $table->string('room_id')->nullable();
            $table->string('device_id')->nullable();
            $table->string('serial_no')->nullable();
            $table->string('calendar_name')->nullable();
            $table->string('room_name')->nullable();
            $table->string('site_code')->nullable();
            $table->string('region')->nullable();
            $table->string('status')->nullable();
            $table->string('health')->nullable();
            $table->string('issue')->nullable();
            $table->string('network_type')->nullable();
            $table->string('camera')->nullable();
            $table->string('microphone')->nullable();
            $table->string('speaker')->nullable();
            $table->string('room_status')->nullable();
            $table->string('device_type')->nullable();
            $table->string('device_system')->nullable();
            $table->string('hostname')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('model')->nullable();
            $table->string('firmware')->nullable();
            $table->string('app_version')->nullable();
            $table->string('ip_address')->nullable();
            $table->text('mac_addresses')->nullable();
            $table->timestamp('last_start_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('zoom_devices');
    }
};
