<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('assets', function (Blueprint $table) {
            $table->after('loaner_retention_date', function (Blueprint $table) {
                $table->date('retain_hold_wipe_confirmed_date')->nullable();
                $table->text('retain_hold_note')->nullable();
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('assets', function (Blueprint $table) {
            $table->dropColumn([
                'retain_hold_wipe_confirmed_date',
                'retain_hold_note',
            ]);
        });
    }
};
