<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('locations', function (Blueprint $table) {
            $table->integer('site_code_id')->nullable()->change();
            $table->integer('region_id')->nullable()->change();
            $table->integer('country_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('locations', function (Blueprint $table) {
            $table->integer('site_code_id')->nullable(false)->change();
            $table->integer('region_id')->nullable(false)->change();
            $table->integer('country_id')->nullable(false)->change();
        });
    }
};
