<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('jump_cloud_devices', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id');
            $table->integer('user_id');
            $table->string('serial_no')->index();
            $table->string('user_name')->nullable();
            $table->string('email')->nullable();
            $table->string('device_id')->index();
            $table->string('device_name')->nullable();
            $table->string('model')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('platform')->nullable();
            $table->string('os')->nullable();
            $table->string('os_version')->nullable();
            $table->ipAddress('ip_address')->nullable();
            $table->string('ram')->nullable();
            $table->string('processor_speed')->nullable();
            $table->string('hard_drive')->nullable();
            $table->string('disk_capacity')->nullable();
            $table->string('host_name')->nullable();
            $table->dateTime('last_seen')->nullable();
            $table->timestamps();

            $table->index('asset_id');
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jump_cloud_devices');
    }
};
