<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('slack_notification_credentials', function (Blueprint $table) {
            $table->string('channel_name')->nullable()->after('slug');
            $table->string('channel_id')->nullable()->after('channel_name');
            $table->integer('status')->default(1)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('slack_notification_credentials', function (Blueprint $table) {
            $table->dropColumn('channel_name');
            $table->dropColumn('channel_id');
            $table->dropColumn('status');
        });
    }
};
