<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('revivn_assets', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('asset_id')->nullable()->index();
            $table->string('serial_no')->nullable();
            $table->string('asset_tag')->nullable();
            $table->string('revivn_id')->nullable();
            $table->integer('revivn_pickup_id')->nullable();
            $table->string('model')->nullable();
            $table->string('device_type')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('hard_drive')->nullable();
            $table->string('cpu')->nullable();
            $table->string('ram')->nullable();
            $table->string('year')->nullable();
            $table->string('hdd')->nullable();
            $table->string('lock_codes')->nullable();
            $table->string('cod_url')->nullable();
            $table->string('end_of_life_condition')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('revivn_assets');
    }
};
