<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('retriver_shipment_requests', function (Blueprint $table) {
            $table->id();
            $table->integer('requester_id')->nullable();
            $table->tinyInteger('request_status')->nullable();
            $table->string('device')->nullable();
            $table->boolean('request_disposal')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('address_line_1')->nullable();
            $table->string('address_line_2')->nullable();
            $table->string('address_city')->nullable();
            $table->string('address_state')->nullable();
            $table->string('address_country')->nullable();
            $table->string('address_zip')->nullable();
            $table->integer('location')->nullable();
            $table->string('return_recipient_name')->nullable();
            $table->string('return_address_company')->nullable();
            $table->string('return_address_line_1')->nullable();
            $table->string('return_address_line_2')->nullable();
            $table->string('return_address_city')->nullable();
            $table->string('return_address_state')->nullable();
            $table->string('return_address_country')->nullable();
            $table->string('return_address_zip')->nullable();
            $table->string('display_name')->nullable();
            $table->string('notification_email')->nullable();
            $table->boolean('return_charger')->nullable();
            $table->boolean('return_phone')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('retriver_shipment_requests');
    }
};
