<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('retriever_devices', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->integer('asset_id')->nullable();
            $table->string('user_email')->nullable();
            $table->string('user_name')->nullable();
            $table->string('city')->nullable();
            $table->string('serial_no');
            $table->string('shipment_status')->nullable();
            $table->text('deactivated_reason')->nullable();
            $table->string('device_type')->nullable();
            $table->boolean('request_charger')->nullable();
            $table->string('outbound_tracking')->nullable();
            $table->string('outbound_carrier')->nullable();
            $table->string('return_tracking')->nullable();
            $table->string('return_carrier')->nullable();
            $table->datetime('box_shipped_at')->nullable();
            $table->datetime('box_delivered_at')->nullable();
            $table->datetime('device_shipped_at')->nullable();
            $table->datetime('device_delivered_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('retriever_devices');
    }
};
