<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_refresh_replacement_jira_mappings', function (Blueprint $table) {
            $table->id();
            $table->string('component_type');
            $table->integer('old_asset_id');
            $table->integer('new_asset_id');
            $table->integer('user_id');
            $table->dateTime('date_requested')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_refresh_replacement_jira_mappings');
    }
};
