<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::rename('admin_login_histories', 'user_login_histories');
        Schema::table('user_login_histories', function (Blueprint $table) {
            $table->string('ip_address')->nullable()->after('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::rename('user_login_histories', 'admin_login_histories');
        Schema::table('user_login_histories', function (Blueprint $table) {
            $table->dropColumn('ip_address');
        });
    }
};
