<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_request_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('client_id')->nullable();
            $table->text('api_url')->nullable();
            $table->string('request_ip')->nullable();
            $table->longText('request_data')->nullable();
            $table->string('request_method')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_request_histories');
    }
};
