<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_blocked_ips', function (Blueprint $table) {
            $table->id();
            $table->string('ip')->unique();
            $table->integer('attempts')->default(1)->nullable();
            $table->integer('total_attempts')->default(1)->nullable();
            $table->dateTime('blocked_at')->nullable();
            $table->dateTime('released_at')->nullable();
            $table->integer('released_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_blocked_ips');
    }
};
