<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('role_change_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->integer('changed_by_user_id')->nullable();
            $table->string('changed_by')->nullable();
            $table->integer('from_user_type_id');
            $table->integer('to_user_type_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('role_change_histories');
    }
};
