<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('zoom_meetings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('zoom_meeting_id');
            $table->string('host_id');
            $table->string('topic');
            $table->tinyInteger('type')->nullable();
            $table->dateTime('start_time')->nullable();
            $table->unsignedBigInteger('duration')->nullable();
            $table->string('timezone')->nullable();
            $table->dateTime('meeting_created_at')->nullable();
            $table->string('join_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('zoom_meetings');
    }
};
