<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssetVulnerabilitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('asset_vulnerabilities', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id')->nullable();
            $table->string('cve_id')->nullable();
            $table->float('base_score', 8, 2)->nullable();
            $table->float('exploitability_score', 8, 2)->nullable();
            $table->string('exprt_rating')->nullable();
            $table->string('severity')->nullable();
            $table->string('status')->nullable();
            $table->string('product_name_normalized')->nullable();
            $table->string('product_name_version')->nullable();
            $table->text('description')->nullable();
            $table->datetime('cve_published')->nullable();
            $table->dateTime('opened_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('asset_vulnerabilities');
    }
}
