<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateZoomMembersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('zoom_members', function (Blueprint $table) {
            $table->id();
            $table->BigInteger('user_id')->nullable();
            $table->string('zoom_user_id')->nullable();
            $table->string('email')->nullable();
            $table->boolean('email_verified')->nullable();
            $table->string('status')->nullable();
            $table->string('name')->nullable();
            $table->dateTime('joined_on')->nullable();
            $table->string('role')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('zoom_members');
    }
}
