<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDropboxMembersListTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dropbox_members', function (Blueprint $table) {
            $table->id();
            $table->BigInteger('user_id')->nullable();
            $table->string('team_member_id')->nullable();
            $table->string('account_id')->nullable();
            $table->string('email')->nullable();
            $table->boolean('email_verified')->nullable();
            $table->string('status')->nullable();
            $table->string('name')->nullable();
            $table->string('membership_type')->nullable();
            $table->dateTime('joined_on')->nullable();
            $table->text('groups')->nullable();
            $table->string('member_folder_id')->nullable();
            $table->string('role')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dropbox_members');
    }
}
