<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVendorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('region_id')->nullable();
            $table->string('country')->nullable();
            $table->boolean('punch_out')->default(0);
            $table->boolean('vendor_stocking')->default(0);
            $table->boolean('advance_payment')->default(0);
            $table->text('asset_type_id')->nullable();
            $table->text('contact_name')->nullable();
            $table->text('contact_email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendors');
    }
}
