<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSoftwareLicenseKeysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('software_license_keys', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('software_license_id');
            $table->foreign('software_license_id')->references('id')->on('software_licenses')->onDelete('cascade');
            $table->text('license_key');
            $table->string('key_usage_type', 20);
            $table->string('users_allowed_for_key');
            $table->string('no_of_users')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('software_license_keys');
    }
}
