<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSoftwareLicenseHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('software_license_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('software_license_id');
            $table->string('action');

            $table->integer('old_software_license_category_id')->nullable();
            $table->integer('new_software_license_category_id')->nullable();
            $table->string('old_software_license_manufacturer_id')->nullable();
            $table->string('new_software_license_manufacturer_id')->nullable();
            $table->integer('old_software_license_vendor_id')->nullable();
            $table->integer('new_software_license_vendor_id')->nullable();
            $table->integer('old_license_purchased')->nullable();
            $table->integer('new_license_purchased')->nullable();
            $table->integer('old_owner_id')->nullable();
            $table->integer('new_owner_id')->nullable();
            $table->string('old_name')->nullable();
            $table->string('new_name')->nullable();
            $table->string('old_po_number')->nullable();
            $table->string('new_po_number')->nullable();
            $table->string('old_order_number')->nullable();
            $table->string('new_order_number')->nullable();
            $table->string('old_license_type')->nullable();
            $table->string('new_license_type')->nullable();
            $table->integer('old_software_license_subscription_id')->nullable();
            $table->integer('new_software_license_subscription_id')->nullable();
            $table->string('old_billing_cycle')->nullable();
            $table->string('new_billing_cycle')->nullable();
            $table->date('old_start_date')->nullable();
            $table->date('new_start_date')->nullable();
            $table->date('old_renewal_date')->nullable();
            $table->date('new_renewal_date')->nullable();
            $table->string('old_auto_renewal')->nullable();
            $table->string('new_auto_renewal')->nullable();
            $table->string('old_subscription_type')->nullable();
            $table->string('new_subscription_type')->nullable();
            $table->string('old_subscription_length')->nullable();
            $table->string('new_subscription_length')->nullable();
            $table->integer('old_licenses_purchased')->nullable();
            $table->integer('new_licenses_purchased')->nullable();
            $table->string('old_license_key_type')->nullable();
            $table->string('new_license_key_type')->nullable();
            $table->string('old_key_usage_type')->nullable();
            $table->string('new_key_usage_type')->nullable();
            $table->text('old_license_key')->nullable();
            $table->text('new_license_key')->nullable();
            $table->string('old_users_allowed_for_key')->nullable();
            $table->string('new_users_allowed_for_key')->nullable();
            $table->string('old_vendor_id')->nullable();
            $table->string('new_vendor_id')->nullable();
            $table->string('software_license_key_id')->nullable();
            $table->integer('old_payment_method_id')->nullable();
            $table->integer('new_payment_method_id')->nullable();
            $table->longText('old_notes')->nullable();
            $table->longText('new_notes')->nullable();
            $table->string('old_status')->nullable();
            $table->string('new_status')->nullable();
            $table->double('old_cost', 8, 2)->nullable();
            $table->double('new_cost', 8, 2)->nullable();
            $table->string('old_type')->nullable();
            $table->string('new_type')->nullable();
            $table->string('document')->nullable();
            $table->string('license_user_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('software_license_histories');
    }
}
