<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSoftwareLicensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('software_licenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('software_license_category_id')->nullable()->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->string('type')->nullable();
            $table->foreignId('software_license_manufacturer_id')->nullable()->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->integer('vendor_id')->nullable();
            $table->integer('owner_id')->nullable();
            $table->string('name')->nullable()->index();
            $table->string('po_number')->nullable();
            $table->string('order_number')->nullable();
            $table->string('license_type')->nullable();
            $table->string('billing_cycle')->nullable();
            $table->date('start_date')->nullable()->index();
            $table->date('renewal_date')->nullable()->index();
            $table->enum('auto_renewal', ['n/a', 'yes', 'no'])->default('n/a');
            $table->string('subscription_length')->nullable();
            $table->integer('software_license_subscription_id')->nullable();
            $table->integer('licenses_purchased')->default(0);
            $table->integer('license_keys_added')->default(0);
            $table->integer('licenses_used')->nullable();
            $table->string('license_key_type')->nullable();
            $table->string('key_usage_type')->nullable();
            $table->string('users_allowed_for_key')->nullable();
            $table->double('cost', 8, 2)->nullable();
            $table->foreignId('payment_method_id')->nullable()->constrained()->onUpdate('cascade')->onDelete('cascade');
            $table->longText('notes')->nullable();
            $table->boolean('status')->default(1);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('software_licenses');
    }
}
