<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserJiraMappingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_jira_mappings', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id');
            $table->string('ticket_no')->nullable();
            $table->string('device_requested')->nullable();
            $table->string('ticket_type')->default('Laptop');
            $table->integer('ticket_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_jira_mappings');
    }
}
