<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAsnHardwareMappingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('asn_hardware_mappings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('part_no', 251);
            $table->string('provider')->nullable();
            $table->integer('make_and_model_id')->nullable();
            $table->integer('technical_spec_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('asn_hardware_mappings');
    }
}
