<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateKandjiDevicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('kandji_devices', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id');
            $table->integer('user_id');
            $table->string('serial_no')->index();
            $table->string('asset_tag')->nullable()->index();
            $table->string('user_name')->nullable()->index();
            $table->string('email')->nullable()->index();
            $table->string('device_id')->index();
            $table->string('device_name')->nullable();
            $table->string('model')->nullable();
            $table->string('platform')->nullable();
            $table->string('os')->nullable();
            $table->string('os_version')->nullable();
            $table->string('processor_speed')->nullable();
            $table->string('ram')->nullable();
            $table->string('disk_capacity')->nullable();
            $table->tinyInteger('activation_lock')->nullable();
            $table->dateTime('last_checkin')->nullable();
            $table->dateTime('first_enrollment')->nullable();
            $table->dateTime('last_enrollment')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kandji_devices');
    }
}
