<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateJamfComputersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jamf_computers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->nullable();
            $table->integer('location_id')->nullable();
            $table->string('user_name')->nullable();
            $table->integer('asset_id')->nullable();
            $table->string('jamf_email')->nullable();
            $table->string('serial_no');
            $table->string('jamf_device_id')->nullable();
            $table->string('name')->nullable();
            $table->ipAddress('ip_address')->nullable();
            $table->string('os_version')->nullable();
            $table->string('os_buid')->nullable();
            $table->string('model')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('mac_address')->nullable();
            $table->string('udid')->nullable();
            $table->dateTime('checkin_date')->nullable();
            $table->string('hard_drive')->nullable();
            $table->string('disk_capacity')->nullable();
            $table->string('ram')->nullable();
            $table->string('processor')->nullable();
            $table->string('processor_speed')->nullable();
            $table->string('processor_type')->nullable();
            $table->string('device_building')->nullable();
            $table->string('device_room')->nullable();
            $table->string('device_type')->nullable();
            $table->string('inventory_status')->nullable();
            $table->string('api_type')->nullable();
            $table->tinyInteger('file_vault_status')->nullable();
            $table->tinyInteger('activation_lock')->nullable();
            $table->string('recovery_lock_password')->nullable();
            $table->string('file_vault_recovery_key')->nullable();
            $table->string('activation_lock_bypass_code')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jamf_computers');
    }
}
