<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIntuneComputersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('intune_computers', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->integer('asset_id')->nullable();
            $table->string('user_email')->nullable();
            $table->string('user_name')->nullable();
            $table->string('serial_no');
            $table->string('name')->nullable();
            $table->string('os_version')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('model')->nullable();
            $table->string('mac_address')->nullable();
            $table->string('ad_device_id')->nullable();
            $table->string('intune_id')->nullable();
            $table->dateTime('checkin_date')->nullable();
            $table->string('platform')->nullable();
            $table->tinyInteger('activation_lock')->nullable();
            $table->tinyInteger('encrypted')->nullable();
            $table->string('disk_capacity')->nullable();
            $table->string('os')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('intune_computers');
    }
}
