<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAirWatchesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('air_watches', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->text('user_name');
            $table->text('first_name');
            $table->text('last_name');
            $table->text('email');
            $table->text('friendly_name')->nullable();
            $table->string('serial_no')->unique();
            $table->text('model')->nullable();
            $table->string('manufacturer')->nullable();
            $table->dateTime('last_seen')->nullable();
            $table->dateTime('locked_date')->nullable();
            $table->string('ownership')->nullable();
            $table->integer('asset_id')->nullable();
            $table->integer('device_id')->nullable();
            $table->string('imei')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('carrier')->nullable();
            $table->integer('carrier_id')->nullable();
            $table->string('host_name')->nullable();
            $table->string('mac_address')->nullable();
            $table->string('platform')->nullable();
            $table->dateTime('last_enrolled_on')->nullable();
            $table->string('local_host_name')->nullable();
            $table->string('apple_enrollment_status')->nullable();
            $table->string('os_version')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('air_watches');
    }
}
