<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChromebooksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chromebooks', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->string('email');
            $table->string('serial_no')->unique();
            $table->string('chromebook_device_id')->nullable();
            $table->string('model')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('mac_address')->nullable();
            $table->integer('asset_id')->nullable();
            $table->integer('device_id')->nullable();
            $table->string('location')->nullable();
            $table->integer('location_id')->nullable();
            $table->boolean('status')->default(1);
            $table->dateTime('last_sync')->nullable();
            $table->dateTime('last_enrollment_time')->nullable();
            $table->string('host_name')->nullable();
            $table->string('platform')->nullable();
            $table->string('os_version')->nullable();
            $table->string('ram')->nullable();
            $table->string('disk_capacity')->nullable();
            $table->string('processor')->nullable();
            $table->string('processor_speed')->nullable();
            $table->string('ip_address')->nullable();
            $table->string('chrome_status')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chromebooks');
    }
}
