<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMobileIronsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mobile_irons', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('asset_id');
            $table->integer('user_id')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('display_name')->nullable();
            $table->string('ownership')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('carrier')->nullable();
            $table->integer('carrier_id')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('totalCapacity')->nullable();
            $table->string('platform')->nullable();
            $table->string('serial_no')->index();
            $table->string('model')->nullable();
            $table->string('imei')->nullable();
            $table->string('iccid')->nullable();
            $table->string('mac_address')->nullable();
            $table->dateTime('last_checkin')->nullable();
            $table->dateTime('enrolled_date')->nullable();
            $table->string('os_version')->nullable();
            $table->timestamps();

            $table->index('asset_id');
            $table->index('imei');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mobile_irons');
    }
}
