<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateApiCredentialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('api_credentials', function (Blueprint $table) {
            $table->increments('id');
            $table->string('api_name')->nullable();
            $table->string('slug');
            $table->string('url')->nullable();
            $table->string('user_name')->nullable();
            $table->text('password')->nullable();
            $table->string('project')->nullable();
            $table->text('key')->nullable();
            $table->longText('data')->nullable();
            $table->longText('custom_data')->nullable();
            $table->string('account_no')->nullable();
            $table->string('meter_no')->nullable();
            $table->boolean('integration_status')->nullable();
            $table->integer('role_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('api_credentials');
    }
}
