<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReportHistoryVarienceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('report_history_variences', function (Blueprint $table) {
            $table->increments('id');
            $table->date('date')->nullable();
            $table->string('name')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('scanned_by')->nullable();
            $table->integer('match_n')->nullable();
            $table->integer('match_y')->nullable();
            $table->integer('total_assets')->nullable();
            $table->integer('total_assets_scanned')->nullable();
            $table->integer('assets_not_in_db')->nullable();
            $table->integer('assets_not_scanned')->nullable();
            $table->integer('positive_variance')->nullable();
            $table->integer('location_id')->nullable();
            $table->string('asset_type_ids')->nullable();
            $table->string('location_name')->nullable();
            $table->float('accuracy', 8, 2)->nullable();
            $table->double('variance')->nullable();
            $table->string('report_csv')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('report_history_variences');
    }
}
