<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccessoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accessories', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('location_id');
            $table->integer('make_and_model_id');
            $table->integer('technical_spec_id');
            $table->integer('available_quantity')->default(0);
            $table->integer('weekly_demand')->default(0);
            $table->integer('lead_time')->default(0);
            $table->integer('order_quantity')->default(0);
            $table->boolean('purchase_indicator')->default(0);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accessories');
    }
}
