<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAssetHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('asset_histories', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->integer('asset_id');
            $table->string('ticket_no')->nullable();
            $table->string('action');
            $table->string('ticket_service_provider');
            $table->integer('old_parent_asset_id')->nullable();
            $table->integer('new_parent_asset_id')->nullable();
            $table->integer('old_location_id')->nullable();
            $table->integer('new_location_id')->nullable();
            $table->integer('old_user_id')->nullable();
            $table->integer('new_user_id')->nullable();
            $table->date('old_loaner_return_date')->nullable();
            $table->date('new_loaner_return_date')->nullable();
            $table->date('old_loaner_retention_date')->nullable();
            $table->date('new_loaner_retention_date')->nullable();
            $table->integer('old_asset_status_id')->nullable();
            $table->integer('new_asset_status_id')->nullable();
            $table->integer('old_lock_status_id')->nullable();
            $table->integer('new_lock_status_id')->nullable();
            $table->text('lock_note')->nullable();
            $table->string('lock_code')->nullable();
            $table->string('old_value')->nullable();
            $table->string('new_value')->nullable();
            $table->text('comments')->nullable();
            $table->text('description')->nullable();
            $table->string('wipe_confirmation')->nullable();
            $table->string('created_by')->nullable();
            $table->timestamps();

            $table->index(['action', 'created_at']);
            $table->index('asset_id');
            $table->index('new_user_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('asset_histories');
    }
}
