<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTechnicalSpecsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('technical_specs', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('make_and_model_id');
            $table->string('details');
            $table->float('original_value', 8, 2);
            $table->float('new_value', 8, 2);
            $table->integer('life_of_asset')->default(4)->nullable();
            $table->boolean('status')->default(1);
            $table->integer('auto_created')->default(0);
            $table->timestamps();

            $table->foreign('make_and_model_id')->references('id')->on('make_and_models')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('technical_specs');
    }
}
