<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAssetsTable extends Migration
{
    public function up()
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('location_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('po_id');
            $table->integer('vendor_id')->nullable();
            $table->integer('asset_type_id');
            $table->integer('make_and_model_id')->nullable();
            $table->integer('technical_spec_id')->nullable();
            $table->string('asset_tag');
            $table->string('serial_no')->unique();
            $table->integer('asset_status_id')->nullable();
            $table->integer('lock_status_id')->nullable();
            $table->string('lock_code')->nullable();
            $table->text('lock_note')->nullable();
            $table->string('imei')->nullable();
            $table->integer('carrier_id')->nullable();
            $table->date('date_deployed')->nullable();
            $table->date('lease_start_date')->nullable();
            $table->date('lease_end_date')->nullable();
            $table->date('loaner_return_date')->nullable();
            $table->date('loaner_retention_date')->nullable();
            $table->string('ticket_no');
            $table->text('comments')->nullable();
            $table->integer('parent_asset_id')->nullable();

            $table->ipAddress('ip')->nullable();
            $table->macAddress('mac')->nullable();
            $table->date('linked_date')->nullable();
            $table->date('lost_date')->nullable();
            $table->date('cancelled_date')->nullable();
            $table->date('end_of_life_date')->nullable();

            $table->string('wipe_confirmation')->nullable();
            $table->string('ewaste_vendor')->nullable();
            $table->string('ewaste_certificate')->nullable();
            $table->string('donation_organization')->nullable();
            $table->string('asset_original_value')->nullable();
            $table->string('asset_deprecated_value')->nullable();
            $table->integer('requestor_id')->nullable();
            $table->string('host_name')->nullable();
            $table->dateTime('last_status_update')->nullable();
            $table->integer('asset_tracking_id')->nullable();
            $table->string('description')->nullable();
            $table->string('part_no', 291)->nullable();
            $table->date('warranty_end_date')->nullable();
            $table->date('certificate_added_date')->nullable();
            $table->string('unlock_code')->nullable();
            $table->string('lock_status')->nullable();
            $table->string('lock_notes')->nullable();
            $table->timestamps();

            $table->index(['asset_type_id', 'created_at']);
            $table->index(['make_and_model_id', 'technical_spec_id']);
            $table->index('parent_asset_id');
            $table->index(['user_id', 'asset_tag']);
            $table->index(['user_id', 'serial_no']);
            $table->index(['location_id', 'asset_tag']);
            $table->index(['location_id', 'serial_no']);
            $table->index(['asset_status_id']);
            $table->index('carrier_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('assets');
    }
}
