<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('locations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('resource_id')->nullable();
            $table->integer('site_code_id');
            $table->integer('location_type_id');
            $table->string('room_name');
            $table->text('address');
            $table->string('building')->nullable();
            $table->text('floor');
            $table->integer('room_capacity')->nullable();
            $table->string('vc')->nullable();
            $table->text('city');
            $table->integer('state_id');
            $table->text('zip');
            $table->integer('region_id');
            $table->integer('country_id');
            $table->boolean('status');
            $table->integer('manually_created')->default(0);
            $table->text('location_email')->nullable();
            $table->boolean('is_freeze')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('locations');
    }
}
