<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('first_name');
            $table->string('last_name');
            $table->string('employee_id')->nullable();
            $table->date('hire_date')->nullable();
            $table->boolean('is_rehire')->nullable();
            $table->string('reason')->nullable();
            $table->string('email');
            $table->date('change_effective_date')->nullable();
            $table->string('business_title')->nullable();
            $table->integer('location_id')->nullable();
            $table->string('city')->nullable();
            $table->integer('country_id')->nullable();
            $table->string('manager_name')->nullable();
            $table->string('supervisory_organization')->nullable();
            $table->string('company')->nullable();
            $table->string('cost_center')->nullable();
            $table->string('position_id')->nullable();
            $table->string('department_id')->nullable();
            $table->date('original_hire_date')->nullable();
            $table->date('terminated_date')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('employee_type_id')->nullable();
            $table->integer('user_type_id');
            $table->text('email_token')->nullable();
            $table->string('password');
            $table->boolean('legalhold')->default(0);
            $table->integer('manager_id')->nullable();
            $table->text('token')->nullable();
            $table->string('okta_id')->nullable();
            $table->integer('state_id')->nullable();
            $table->string('location')->nullable();
            $table->integer('division_id')->nullable();
            $table->boolean('okta_synced')->nullable()->default(0);
            $table->string('personal_email')->nullable();
            $table->string('country_code')->nullable();
            $table->string('theme_preference')->default('light');

            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
