<?php

namespace Database\Factories;

use App\Models\Department;
use App\Models\EmployeePosition;
use App\Models\EmployeeType;
use App\Models\Location;
use App\Models\UserType;
use Illuminate\Database\Eloquent\Factories\Factory;

class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        static $password;

        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        $email = strtolower(substr($firstName, 0, 1) . $lastName) . '@teqtivitydemo.com';

        // Commented unwanted code $sortOrder = find_sort_order($firstName);

        return [
            'first_name' => $firstName,
            'last_name' => $lastName,
            'employee_id' => random_int(999, 9999),
            'email' => $email,
            'location_id' => optional(Location::inRandomOrder()->first())->id,
            'position_id' => EmployeePosition::inRandomOrder()->first()->id,
            'department_id' => optional(Department::inRandomOrder()->first())->id,
            'hire_date' => $this->faker->dateTimeBetween('+1 day', '+1 year'),
            'terminated_date' => null,
            'original_hire_date' => null,
            'employee_type_id' => EmployeeType::inRandomOrder()->first()->id,
            'user_type_id' => UserType::first()->id,
            'password' => $password ?: $password = bcrypt($email),
            'remember_token' => str_random(10),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    public function unverified()
    {
        return $this->state(function (array $attributes) {
            return [
                'email_verified_at' => null,
            ];
        });
    }
}
