<?php

namespace Database\Factories;

use App\Models\MakeAndModel;
use Illuminate\Database\Eloquent\Factories\Factory;

class TechnicalSpecsFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $details = $this->faker->randomElement(array('1 GB RAM, 16 MP Camera', '2 GB RAM, 16 MP Camera', '4 GB RAM, 16 MP Camera'));

        return [
            'make_and_model_id' => MakeAndModel::inRandomOrder()->first()->id,
            'details' => $details,
            'original_value' => random_int(10, 999),
            'new_value' => random_int(10, 999),
        ];
    }
}
