<?php

namespace Database\Factories\SoftwareLicense;

use App\Models\SoftwareLicense\PaymentMethod;
use App\Models\SoftwareLicense\SoftwareLicenseCategory;
use App\Models\SoftwareLicense\SoftwareLicenseManufacturer;
use App\Models\SoftwareLicense\SoftwareLicenseSubscription;
use App\Models\Vendor;
use Illuminate\Database\Eloquent\Factories\Factory;

class SoftwareLicenseFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $licenseTypes = array_keys(config('software-license.license_types'));
        $licenseType = $licenseTypes[random_int(0, count($licenseTypes) - 1)];
        $billingCycles = array_keys(config('software-license.billing_cycles'));
        $status = array_keys(config('software-license.licence_status'));
        $licenseKeyTypes = array_keys(config('software-license.license_key_types'));
        $licenseKeyType = $licenseKeyTypes[random_int(0, count($licenseKeyTypes) - 1)];
        $keyUsageTypes = array_keys(config('software-license.key_usage_types'));
        $keyUsageType = $licenseKeyType != 'no_license' ? $keyUsageTypes[random_int(0, count($keyUsageTypes) - 1)] : '';
        $usersPerKey = $keyUsageType == 'limited_usage' ? 5 : '';

        // $notificationDates = array_keys(config('software-license.notification_period'));
        return [
            'software_license_manufacturer_id' => SoftwareLicenseManufacturer::inRandomOrder()->value('id'),
            'software_license_category_id' => SoftwareLicenseCategory::inRandomOrder()->value('id'),
            'vendor_id' => Vendor::inRandomOrder()->value('id'),
            'name' => $this->faker->name(),
            'po_number' => $this->faker->randomNumber(),
            'order_number' => $this->faker->randomNumber(),
            'license_type' => $licenseType,
            'billing_cycle' => $billingCycles[random_int(0, count($billingCycles) - 1)],
            'start_date' => $this->faker->date(),
            'renewal_date' => $licenseType == 'subscription' ? $this->faker->date() : '',
            'auto_renewal' => 'yes',
            'software_license_subscription_id' => $licenseType == 'subscription' ? SoftwareLicenseSubscription::inRandomOrder()->value('id') : '',
            'licenses_purchased' => $this->faker->numberBetween(10, 20),
            'license_keys_added' => $this->faker->numberBetween(0, 10),
            'payment_method_id' => PaymentMethod::inRandomOrder()->value('id'),
            'notes' => $this->faker->text(),
            'status' => $status[random_int(0, count($status) - 1)],
            'license_key_type' => $licenseKeyType,
            'key_usage_type' => $keyUsageType,
            'users_allowed_for_key' => $usersPerKey
        ];
    }
}
