<?php

namespace Database\Factories\SoftwareLicense;

use App\Models\SoftwareLicense\PaymentMethod;
use App\Models\SoftwareLicense\SoftwareLicenseManufacturer;
use Illuminate\Database\Eloquent\Factories\Factory;

class LicenseFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $licenseTypes = array_keys(config('software-license.license_types'));
        $billingCycles = array_keys(config('software-license.billing_cycles'));
        $subscriptionLength = array_keys(config('software-license.subscription_length'));
        $status = array_keys(config('software-license.licence_status'));
        return [
            'software_license_vendor_id' => SoftwareLicenseManufacturer::inRandomOrder()->value('id'),
            'name' => $this->faker->name(),
            'po_number' => $this->faker->randomNumber(),
            'order_number' => $this->faker->randomNumber(),
            'license_type' => $licenseTypes[random_int(0, count($licenseTypes) - 1)],
            'billing_cycle' => $billingCycles[random_int(0, count($billingCycles) - 1)],
            'start_date' => $this->faker->date(),
            'renewal_date' => $this->faker->date(),
            'auto_renewal' => 'yes',
            'subscription_length' => $subscriptionLength[random_int(0, count($subscriptionLength) - 1)],
            'licenses_purchased' => $this->faker->numberBetween(10, 20),
            'license_keys_added' => $this->faker->numberBetween(0, 10),
            'payment_method_id' => PaymentMethod::inRandomOrder()->value('id'),
            'notes' => $this->faker->text(),
            'status' => $status[random_int(0, count($status) - 1)],
        ];
    }
}
