<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\RevivnPickup>
 */
class RevivnPickupFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'pickup_id' => Str::uuid(),
            'state' => $this->faker->randomElement(['complete', 'pending', 'in_progress']),
            'order_number' => strtoupper($this->faker->bothify('???###??')), // e.g., '320BF00F'
            'comments' => $this->faker->optional()->sentence,
            'confirmed_time' => $this->faker->time('h:i A'), // e.g., '9:00 AM'
            'scheduled_date' => $this->faker->date('Y-m-d'), // e.g., '2023-12-04'
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
