<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\Carrier;
use App\Models\MakeAndModel;
use App\Models\Manufacturer;
use App\Models\MobileIron;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class MobileIronFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        $int = random_int(1649862000, 1660402800);
        $created_at = date("Y-m-d H:i:s", $int);

        // Retrieve the existing array from the session or initialize a new empty array
        $oldSerials = session()->get('mobsession', []);

        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $oldSerials)
            ->whereHas('assetType', fn($query) => $query->whereIn('slug', ['mobile_phone', 'tablet']))
            ->inRandomOrder()->distinct()->first(), 0]);

        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');

        $oldSerials[] = $serialNo;
        session()->put('mobsession', $oldSerials);

        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        $userName = $firstName . '.' . $lastName;

        $user = $this->faker->randomElement([0, 0, User::inRandomOrder()->first(), 0]);

        $userId = $user ? $user->id : 0;

        $carrier = Carrier::inRandomOrder()->first();

        $lastdatetime = $this->faker->dateTimeBetween('-1 year', 'now');
        $lastSeenDatetime = $lastdatetime->format("Y-m-d H:i:s");

        $lastSeenDatetime = Carbon::createFromFormat("Y-m-d H:i:s", $lastSeenDatetime)->timestamp * 1000;

        return [
            'asset_id' => $asset ? $asset->id : 0,
            'user_id' => $userId,
            'first_name' => $firstName,
            'last_name' => $lastName,
            'email' => $user ? $user->email : $userName . '@company.com',
            'display_name' => $firstName . $lastName,
            'ownership' => $this->faker->randomElement(['Corporate', 'Employee', 'Shared']),
            'phone_number' => $this->faker->randomElement([$this->faker->phoneNumber(), NULL]),
            'carrier' => $carrier->name,
            'carrier_id' => $carrier->id,
            'manufacturer' => Manufacturer::inRandomOrder()->first()->name,
            'totalCapacity' => $this->faker->randomElement(['1GB', '2GB', '4GB', '8GB', '16GB']),
            'platform' => $this->faker->randomElement(['WINDOWS_PHONE', 'APPLE_LAPTOP']),
            'serial_no' => $serialNo,
            'model' => MakeAndModel::inRandomOrder()->first()->name,
            'imei' => str_random(10),
            'iccid' => str_random(10),
            'mac_address' => $this->faker->macAddress(),
            'last_checkin' => $lastSeenDatetime,
            'enrolled_date' => $created_at,
            'created_at' => $created_at,
            'updated_at' => $created_at
        ];
    }
}
