<?php

namespace Database\Factories;

use App\Models\LocationType;
use App\Models\SiteCode;
use Illuminate\Database\Eloquent\Factories\Factory;

class LocationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {

        $siteCode = SiteCode::inRandomOrder()->first();

        return [
            'site_code_id' => $siteCode->id,
            'location_type_id' => LocationType::inRandomOrder()->first()->id,
            'room_name' => $this->faker->word(),
            'address' => $this->faker->address(),
            'building' => $this->faker->buildingNumber(),
            'floor' => $this->faker->numberBetween($min = 0, $max = 175),
            'region_id' => $siteCode->region_id,
            'country_id' => $siteCode->country_id,
            'status' => 1,
            'location_email' => $this->faker->safeEmail(),
        ];
    }
}
