<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\KandjiDevices;
use App\Models\MakeAndModel;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class KandjiDevicesFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        // Retrieve the existing array from the session or initialize a new empty array
        $oldSerials = session()->get('jamfsession', []);

        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $oldSerials)
            ->whereHas('assetType', fn($query) => $query->whereIn('slug', ['laptop', 'desktop', 'mobile_phone', 'tablet']))
            ->whereHas(
                'makeAndModel',
                fn($query) => $query
                    ->whereHas('manufacturer', fn($query) => $query->whereIn('slug', ['apple']))
            )
            ->inRandomOrder()->distinct()->first(), 0]);

        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');

        $oldSerials[] = $serialNo;
        session()->put('jamfsession', $oldSerials);

        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        $userName = $firstName . '.' . $lastName;

        $user = $this->faker->randomElement([0, 0, User::inRandomOrder()->first(), 0]);

        $userId = $user ? $user->id : 0;

        $lastdatetime = $this->faker->dateTimeBetween('-1 year', 'now');
        $lastSeenDatetime = $lastdatetime->format("Y-m-d H:i:s");

        $lastSeenDatetime = Carbon::createFromFormat("Y-m-d H:i:s", $lastSeenDatetime)->format('Y-m-d\TH:i:s\Z');


        $macModels = [
            'MacBook Air (M1, 2020)',
            'MacBook (12-inch, 2015)',
            'MacBook (12-inch, Early 2016)',
            'MacBook (12-inch, Mid 2017)',
            'MacBook Air (11-inch, Early 2015)',
            'MacBook Air (Retina, 13-inch, 2020)',
            'MacBook Pro (13-inch, M1, 2020)',
            'MacBook Pro (15-inch, 2016)',
            'MacBook Pro (15-inch, 2017)',
            'MacBook Air (Retina, 13-inch, 2018 - 2019)',
            'MacBook Pro (13-inch, M1, 2020)',
            'MacBook Pro (13-inch, 2020)',
            'MacBook Pro (16-inch, 2019)',
            'MacBook Pro (Retina, 15-inch, Mid 2015 - 2019)',
            'MacBook Pro (Retina, 13-inch, Early 2015 - 2019)',
            'MacBook (Retina, 12-inch, Early 2015 - 2017)',
            'iMac (Retina 5K, 27-inch, 2020)',
            'iMac (Retina 4K, 21.5-inch, 2019)',
            'iMac (Retina 5K, 27-inch, 2019)',
            'iMac (Retina 4K, 21.5-inch, 2017 - 2019)',
            'iMac (Retina 5K, 27-inch, Late 2014 - 2015)',
            'iMac (21.5-inch, 2017)',
            'iMac (21.5-inch, Late 2015)',
            'Mac mini (M1, 2020)',
            'Mac mini (2018)',
            'Mac mini (Late 2014)',
            'Mac Pro (2019)',
            'Mac Pro (Late 2013)',
        ];

        return [
            'asset_id' => $asset ? $asset->id : 0,
            'user_id' => $userId,
            'serial_no' => $serialNo,
            'asset_tag' => $serialNo,
            'user_name' => $userName,
            'email' => $user ? $user->email : $userName . '@company.com',
            'device_id' => $this->faker->bothify('?????-##?????-???#???-???##'),
            'device_name' => $this->faker->word(),
            'model' => $this->faker->randomElement($macModels),
            'platform' => 'mac',
            'os' => 'OSX',
            'os_version' => '10.0..' . $this->faker->numerify('##'),
            'processor_speed' => $this->faker->randomElement(['1.8 GHz', '2.0 GHz', '2.2 GHz', '2.4 GHz', '2.6 GHz', '2.8 GHz', '3.0 GHz', '3.2 GHz', '3.4 GHz', '3.6 GHz']),
            'ram' => $this->faker->randomElement(['2GB', '4GB', '8GB', '16GB', '32GB', '64GB']),
            'disk_capacity' => $this->faker->randomElement(['256GB', '500GB', '1TB', '2TB']),
            'activation_lock' => 0,
            'last_checkin' => $lastSeenDatetime,
        ];
    }
}
