<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\JamfComputer;
use App\Models\MakeAndModel;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class JamfComputerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        // Retrieve the existing array from the session or initialize a new empty array
        $oldSerials = session()->get('jamfsession', []);

        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $oldSerials)
            ->whereHas('assetType', fn($query) => $query->whereIn('slug', ['laptop', 'desktop', 'mobile_phone', 'tablet']))
            ->whereHas(
                'makeAndModel',
                fn($query) => $query
                    ->whereHas('manufacturer', fn($query) => $query->whereIn('slug', ['apple']))
            )
            ->inRandomOrder()->distinct()->first(), 0]);

        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');

        $oldSerials[] = $serialNo;
        session()->put('jamfsession', $oldSerials);

        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        $userName = $firstName . '.' . $lastName;

        $user = $this->faker->randomElement([0, 0, User::inRandomOrder()->first(), 0]);

        $userId = $user ? $user->id : 0;

        $lastdatetime = $this->faker->dateTimeBetween('-1 year', 'now');
        $lastSeenDatetime = $lastdatetime->format("Y-m-d H:i:s");

        $lastSeenDatetime = Carbon::createFromFormat("Y-m-d H:i:s", $lastSeenDatetime)->format('Y-m-d\TH:i:s\Z');


        return [
            'user_id' => $userId,
            'asset_id' => $asset ? $asset->id : 0,
            'user_name' => $userName,
            'jamf_email' => $user ? $user->email : $userName . '@company.com',
            'serial_no' => $serialNo,
            'name' => $this->faker->word(),
            'os_version' => '10.0..' . $this->faker->numerify('##'),
            'os_buid' => $this->faker->randomElement(['20G165', '20G95', '20G314', '20G415', '20D91']),
            'model' => $this->faker->randomElement(['MacBookPro16,3', 'MacBookPro14,1', 'MacBookPro16,1', 'MacBookAir9,1', 'MacBookPro16,2', 'iMac20,1', 'MacBookAir10,1', 'MacBookPro17']),
            'mac_address' => $this->faker->macAddress(),
            'udid' => $this->faker->bothify('?????-##?????-???#???-???##'),
            'checkin_date' => $lastSeenDatetime,
            'hard_drive' => $this->faker->randomElement(['APPLE SSD AP0512N', 'APPLE SSD AP0128J', 'APPLE SSD AP0256N', 'APPLE SSD AP1024N', 'APPLE SSD AP2048N', 'APPLE SSD AP0256Q', 'APPLE SSD AP0512Q']),
            'disk_capacity' => $this->faker->bothify('########'),
            'ram' => $this->faker->bothify('#####'),
            'processor' => $this->faker->randomElement(['Quad-Core Intel Core i5', 'Dual-Core Intel Core i5', '6-Core Intel Core i7', 'Dual-Core Intel Core i3', 'Quad-Core Intel Core i7', '8-Core Intel Core i9', '6-Core Intel Core i5', 'Apple M1']),
            'processor_speed' => $this->faker->randomElement([0, 2600, 600, 8000, 0, 1100, 3300]),
        ];
    }
}
