<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\IntuneComputer;
use App\Models\MakeAndModel;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class IntuneComputerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        // Retrieve the existing array from the session or initialize a new empty array
        $oldSerials = session()->get('intunesession', []);

        $asset = $this->faker->randomElement([0, 0, Asset::whereNotIn('serial_no', $oldSerials)
            ->whereHas('assetType', fn($query) => $query->whereIn('slug', ['laptop', 'desktop', 'mobile_phone', 'tablet']))
            ->whereHas(
                'makeAndModel',
                fn($query) => $query
                    ->whereHas('manufacturer', fn($query) => $query->whereIn('slug', ['dell', 'lenovo']))
            )
            ->inRandomOrder()->distinct()->first(), 0]);


        $serialNo = $asset ? $asset->serial_no : $this->faker->unique()->regexify('[A-Z]{4}[0-9]{4}');

        $oldSerials[] = $serialNo;
        session()->put('intunesession', $oldSerials);


        $firstName = $this->faker->firstName();
        $lastName = $this->faker->lastName();
        $userName = $firstName . '.' . $lastName;

        $user = $this->faker->randomElement([0, 0, User::inRandomOrder()->first(), 0]);

        $userId = $user ? $user->id : 0;

        $hardWare = MakeAndModel::whereHas('manufacturer', fn($query) => $query->whereIn('slug', ['dell', 'lenovo']))->inRandomOrder()->first();

        $lastdatetime = $this->faker->dateTimeBetween('-1 year', 'now');
        $lastSeenDatetime = $lastdatetime->format("Y-m-d H:i:s");

        $lastSeenDatetime = Carbon::createFromFormat("Y-m-d H:i:s", $lastSeenDatetime)->format('Y-m-d\TH:i:s\Z');


        return [
            'user_id' => $userId,
            'asset_id' => $asset ? $asset->id : 0,
            'user_email' => $user ? $user->email : $userName . '@company.com',
            'user_name' => $userName,
            'serial_no' => $serialNo,
            'name' => $this->faker->word(),
            'os_version' => '10.0.19043.' . $this->faker->numerify('####'),
            'manufacturer' => optional($hardWare->manufacturer)->name,
            'model' => $hardWare->name,
            'mac_address' => $this->faker->macAddress(),
            'ad_device_id' => $this->faker->bothify('?????-##?????-???#???-???##'),
            'intune_id' => $this->faker->bothify('???????##?#?-##?????-???#???-???##'),
            'checkin_date' => $lastSeenDatetime,
            'disk_capacity' => $this->faker->bothify('########'),
        ];
    }
}
